#include <qei.h>
#include <p30fxxxx.h>

/* QEI is defined in following devices */
#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F5015__)

/**************************************************************************
* Function Name     : CloseQEI()
* Description       : This routine disables the QEI and its interrupt bits. 
* Parameters        : None
* Return Value      : None
***************************************************************************/

void CloseQEI(void)
{
    IEC2bits.QEIIE = 0;     /* disable interrupt */
    QEICONbits.QEIM = 0x0;  /* QEI/Timer off */  
    IFS2bits.QEIIF = 0;     /* clear IF flag */       
}

#endif
